/**
 * Скрипт для автоматической фильтрации при прямом переходе по URL
 */
jQuery(document).ready(function($) {
    /**
     * Функция для получения параметров из URL
     * @returns {Object} - объект с параметрами URL
     */
    function getUrlParams() {
        var params = {};
        var search = window.location.search.substring(1);
        if (search) {
            var pairs = search.split('&');
            for (var i = 0; i < pairs.length; i++) {
                var pair = pairs[i].split('=');
                params[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1] || '');
            }
        }
        return params;
    }

    /**
     * Функция для автоматического запуска AJAX-запроса при загрузке страницы
     */
    function autoFilterOnLoad() {
        var urlParams = getUrlParams();
        
        // Проверяем, есть ли параметр make в URL
        if (urlParams.make) {
            console.log('Auto filter detected make:', urlParams.make);
            
            // Показываем индикатор загрузки
            $('#pix-ajax-loader,.pix-auto-wrapper-loader').addClass('ajax-loading');
            
            // Устанавливаем значение в селект марки
            $('#ajax-make').val(urlParams.make);
            $('.jelect-current:first').text($('.jelect-options li[data-val="' + urlParams.make + '"]').text());
            
            // Формируем данные для AJAX-запроса
            var data = {
                action: 'process_reservation',
                post_style: $('#pixad-listing').attr("class"), 
                nonce: pixadAjax.nonce,
                make: urlParams.make
            };
            
            // Отправляем AJAX-запрос для загрузки моделей
            $.get(pixadAjax.url, {
                action: 'process_reservation',
                nonce: pixadAjax.nonce,
                make_model: urlParams.make
            }, function(response) {
                console.log('AJAX response models:', response.data);
                $('.jelect-options.pixad-model').html(response.data);
                
                // Если есть параметр model, устанавливаем его в селект модели
                if (urlParams.model) {
                    $('#pixad-model').val(urlParams.model);
                    data.model = urlParams.model;
                    $('.jelect-current.pixad-model').text($('.jelect-options.pixad-model li[data-val="' + urlParams.model + '"]').text());
                }
                
                // Отправляем AJAX-запрос для фильтрации автомобилей
                $.get(pixadAjax.url, data, function(response) {
                    console.log('AJAX response listing:', response.data);
                    $('#pixad-listing').html(response.data);
                    $(document).trigger('filterRefreeshPage');
                    
                    // Скрываем индикатор загрузки
                    $('#pix-ajax-loader,.pix-auto-wrapper-loader').removeClass('ajax-loading');
                });
            });
        }
    }
    
    // Запускаем автоматическую фильтрацию при загрузке страницы
    autoFilterOnLoad();
});
